﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
namespace DistanceCounter
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();


            var mouseMove = Observable.FromEvent<MouseEventArgs>(this, "MouseMove").Throttle(new TimeSpan(0,0,0,0,100));

            var distanceObs = mouseMove.Skip(1).Zip(mouseMove, (a ,b) => (DistanceCalc(a,b)));
            //not working yet
            var totalObs = distanceObs.Scan(new { sum = 0d }, (agg, b) => new { sum = agg.sum + b }).Select(a => a.sum);
            var sub = totalObs.Subscribe(x => this.lblDistance.Text = x.ToString());

            distanceObs.Subscribe(x => Trace.WriteLine("meep"));


        }

        private double DistanceCalc(IEvent<MouseEventArgs> a, IEvent<MouseEventArgs> b)
        {
            
            var A = a.EventArgs;
            var B = b.EventArgs;

            Trace.WriteLine(A.X + " - " + A.Y + "  " + B.X + " - " + B.Y);
            var ret = Math.Sqrt(Math.Pow((A.X - B.X), 2) + Math.Pow((A.Y - B.Y), 2));
            Trace.WriteLine(ret);
            return ret;
        }
    }
}
