﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace MiddleOfForm
{
    public partial class Form1 : Form
    {

        public double distanceFromMiddle(int x, int y)
        {
            Point p = new Point(this.Width / 2, this.Height / 2);
            var a = (x - p.X);
            var b = (y - p.Y);
            var ret = Math.Sqrt(Math.Pow(a, 2) + Math.Pow(b, 2)) ;
            return ret;
        }

        public Form1()
        {
            InitializeComponent();
            var mouseMove = Observable.FromEvent<MouseEventArgs>(this, "MouseMove").Throttle(TimeSpan.FromMilliseconds(50));

            var filteredEvent = mouseMove.Where(ev => distanceFromMiddle(ev.EventArgs.X, ev.EventArgs.Y) < 50);

            var subscription = filteredEvent.Subscribe(
                                x => lblMiddle.BackColor = Color.Green
                                 );
           //Reset after 2 seconds
           var subscription2 = filteredEvent.Delay(TimeSpan.FromSeconds(2)).Subscribe(x => lblMiddle.BackColor = Color.Transparent);

            
            

            this.Load += new EventHandler(Form1_Load);
            
        }

        void Form1_Load(object sender, EventArgs e)
        {
            this.Height = 500;
            this.Width = 500;
            this.Paint += new PaintEventHandler(Form1_Paint);
            
        }

        void Form1_Paint(object sender, PaintEventArgs e)
        {
            this.CreateGraphics().DrawEllipse(new Pen(Brushes.Black, 5), this.Width / 2 - 50, this.Height / 2 - 50, 100, 100);
        }
    }
}
