﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;

namespace RxJS
{
    public partial class GetService : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            Random r = new Random();
            List<IJson> ret = new List<IJson>();

            //Simulate some slowness
            System.Threading.Thread.Sleep(3000);
            
            switch (Request.QueryString["Service"])
            {

                case "GetPeople":
                    ret.Add(new Person { Name = "Fred Smith", Interest = "Football" });
                    ret.Add(new Person { Name = "Charlie Brown", Interest = "Basketball" });
                    ret.Add(new Person { Name = "Peter Newton", Interest = "Football" });
                    ret.Add(new Person { Name = "John Jones", Interest = "Tennis" });
                    ret.Add(new Person { Name = "Adrian Green", Interest = "Cricket" });
                    break;
                case "FakeSearch":
                    int furtherDelay = int.Parse(Request.QueryString["furtherDelay"]) * 1000;
                    string Term = Request.QueryString["Term"];
                    ret.Add(new SearchResult { Term = Term, Count = r.Next(500) });

                    break;

                default:

                    break;



            }

            var entity = ret[0].Entity;
            string retVal = "{";
            retVal += "\"" + entity + "\": [\r\n";
            foreach (var o in ret)
            {
                retVal += "\r\n" + o.GetJson() + ",";
            }
            retVal = retVal.Trim(',');
            retVal += "\r\n ] }";

            Response.Clear();
            Response.Write(retVal);






        }
    }

    public class SearchResult : IJson  
    {
        public string Term { get; set; }
        public int Count { get; set; }
        public string Entity
        {
            get { return "Results"; }
        }

        public string GetJson()
        {

            return "{ \"Term\": " + Term + ", \"Count\": \"" + Count + "\" }"; 
        }
    }


    public class Person : IJson
    {
        public static int id = 0;
        public Person()
        {
            id++;
            Id = id;
        }

        public string Name { get; set; }
        public string Interest { get; set; }
        public int Id {get;set;}
        public string GetJson()
        {
            return "{ \"Id\": " + Id + ", \"Name\": \"" + Name + "\", \"Interest\": \"" + Interest + "\" }"; 
        }
        public string Entity
        {
            get
            {
                return "People";
            }
        }
    }



    public interface IJson
    {
        string Entity { get; }
        string GetJson();
    }
}