﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Concurrency;

namespace WindowsFormsApplication1
{
    public partial class Form1 : Form
    {
        IObservable<IEvent<MouseEventArgs>> mouseMove;
        IDisposable subscription;

        public void DrawBlackCircle(int x, int y, int width)
        {
            this.CreateGraphics().DrawEllipse(new Pen(Brushes.Black), x, y, width, width);
        }
        public void DrawThickRedCircle(int x, int y, int width)
        {
            this.CreateGraphics().DrawEllipse(new Pen(Brushes.Red, 5f), x, y, width, width);
        }

        private void Form1_Load(object sender, EventArgs e)
        {

            mouseMove = Observable.FromEvent<MouseEventArgs>(this, "MouseMove");

            subscription = mouseMove.SubscribeOn(this).Subscribe(
                                args => DrawBlackCircle(args.EventArgs.X, args.EventArgs.Y, 12)
                     );




















            
            //for (int iC = 0; iC < 10; iC++)
            //{
            //    var j = iC;
            //    mouseMove.Throttle(TimeSpan.FromMilliseconds(100))
            //        .Delay(TimeSpan.FromMilliseconds(100 * iC))
            //        .SubscribeOn(this).Subscribe(
            //                     args => DrawThickRedCircle(args.EventArgs.X + j, args.EventArgs.Y + j, 24 - (2 * j))
            //                       );
            //}

        }
        public Form1()
        {
            InitializeComponent();
        }


    }
}
