﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Joins;
using System.Diagnostics;

namespace WindowsFormsApplication2
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();


        }

        private void Form1_Load(object sender, EventArgs e)
        {

            var mouseMove = Observable.FromEvent<MouseEventArgs>(this, "MouseMove");//.Throttle(TimeSpan.FromMilliseconds(100));


            var left = mouseMove.Where(arg => arg.EventArgs.X < this.Width / 2);
            var right = mouseMove.Where(arg => arg.EventArgs.X > this.Width / 2);

            var top = mouseMove.Where(arg => arg.EventArgs.Y < this.Height / 2);

            var bottom = mouseMove.Where(arg => arg.EventArgs.Y > this.Height / 2);


            var topleftJoins = Observable.Join(left.And(top).Then((a, b) => a));
            var toprightJoins = Observable.Join(right.And(top).Then((a, b) => a));
            var bottomleftJoins = Observable.Join(left.And(bottom).Then((a, b) => a));
            var bottomrightJoins = Observable.Join(right.And(bottom).Then((a, b) => a));



            //mouseMove.Subscribe(x => Trace.WriteLine("MouseMove" + x.EventArgs.X + " " + x.EventArgs.Y));

            //left.Subscribe(x => Trace.WriteLine("left" + x.EventArgs.X + " " + x.EventArgs.Y));
            //top.Subscribe(x => Trace.WriteLine("top" + x.EventArgs.X + " " + x.EventArgs.Y));
            //right.Subscribe(x => Trace.WriteLine("right" + x.EventArgs.X + " " + x.EventArgs.Y));
            //bottom.Subscribe(x => Trace.WriteLine("bottom" + x.EventArgs.X + " " + x.EventArgs.Y));

            //topleftJoins.Subscribe(x => Trace.WriteLine("topleft" + x.EventArgs.X + " " + x.EventArgs.Y));
            //toprightJoins.Subscribe(x => Trace.WriteLine("topright" + x.EventArgs.X + " " + x.EventArgs.Y));
            //bottomleftJoins.Subscribe(x => Trace.WriteLine("bottomleft" + x.EventArgs.X + " " + x.EventArgs.Y));
            //bottomrightJoins.Subscribe(x => Trace.WriteLine("bottomright" + x.EventArgs.X + " " + x.EventArgs.Y));


            topleftJoins.Subscribe(x =>
            {
                ResetLabels();
                lblTopLeft.BackColor = Color.Blue;
            });

            bottomleftJoins.Subscribe(x =>
            {
                ResetLabels();
                lblBottomLeft.BackColor = Color.Green;
            });
            toprightJoins.Subscribe(x =>
            {
                ResetLabels();
                lblTopRight.BackColor = Color.Red;
            });
            bottomrightJoins.Subscribe(x =>
            {
                ResetLabels();
                lblBottomRight.BackColor = Color.Yellow;
            });


        }


        private void ResetLabels()
        {
            lblTopLeft.BackColor = Color.Transparent;
            lblTopRight.BackColor = Color.Transparent;
            lblBottomLeft.BackColor = Color.Transparent;
            lblBottomRight.BackColor = Color.Transparent;
        }
        private void tableLayoutPanel1_Paint(object sender, PaintEventArgs e)
        {

        }
    }
}
